<?php

namespace App\Models\ManagerDashboard\Namazeg;

use App\Enums\ReportType;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AbsenceQuestioningAction extends Model
{
    use HasFactory;
    protected $guarded=[];
    protected $table = "namazeg_absence_questioning_actions";

    public function action(){
        return $this->belongsTo(AbsenceQuestioningOption::class, 'absence_questioning_option_id');
    }
    public function descion_confirm(){
        return $this->belongsTo(NamazegAbsenceDescionConfirm::class, 'absence_descion_confirm_id');
    }

    public function getLabelReportTypeAttribute()
    {
        if (!is_null($this->report_type)) {
            $reportType = ReportType::tryFrom($this->report_type);
            return $reportType ? $reportType->label() : null;
        }
        return 'اجازة ضرورية';
    }



}
