<?php

namespace App\Models\ManagerDashboard\Exams\SupervisionCommittees;

use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SupervisionAssignment extends Model
{
    use HasFactory,SoftDeletes;

    protected $table = 'exams_supervision_assignments';

    protected $guarded = [];

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

    public function members()
    {
        return $this->hasMany(SupervisionAssignmentMember::class,'assignment_id');
    }

   
}
