<?php

namespace App\Models\ManagerDashboard\Exams\StudentCommittees;

use App\Models\AdminDashboard\School\SchoolClass;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StudentCommitteeData extends Model
{
    use HasFactory;

    protected $table = 'exams_student_committee_data';

    protected $guarded = [];

    public function SchoolClass()
    {
        return $this->belongsTo(SchoolClass::class,'schoolclass_id');    
    }

    public function studentCommittee()
    {
        return $this->belongsTo(StudentCommittee::class,'student_committee');    
    }

    public function scopeSchool($query, $school_id)
    {
        return $query->where('school_id', $school_id);
    } 

}
