<?php

namespace App\Models\ManagerDashboard\Exams\StudentCommittees;

use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StudentCommittee extends Model
{
    use HasFactory,SoftDeletes;

    protected $table = 'exams_student_committees_table';

    protected $guarded = [];


    public function SchoolClass()
    {
        return $this->belongsTo(SchoolClass::class,'schoolclass_id');    
    }

    public function committeeStudents()
    {
        return $this->hasMany(StudentCommitteeData::class, 'student_committee');
    }

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

    public function semester()
    {
        return $this->belongsTo(SchoolSemester::class);
    }

    public function getSchoolClassNameAttribute()
    {
        return $this->SchoolClass?->className?->name . ' ' . $this->SchoolClass?->class_number;
    }
}
