<?php

namespace App\Models\ManagerDashboard\Exams\NamazegPlans\DailyObservers;

use App\Models\AdminDashboard\School\Subject;
use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentCommittee;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DailyObserves extends Model
{
    use HasFactory,SoftDeletes;

    protected $table = 'exams_namazeg_daily_observers';
    
    protected $guarded = [];

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

    public function exam_comittee()
    {
        return $this->belongsTo(StudentCommittee::class, 'committee_id');
    }

    public function subject()
    {
        return $this->belongsTo(Subject::class, 'subject_id');
    }

}
