<?php

namespace App\Models\ManagerDashboard\ClassRoomVisits;

use App\Models\AdminDashboard\School\ClassName;
use App\Models\AdminDashboard\School\Period;
use App\Models\AdminDashboard\School\Subject;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClassVisitRate extends Model
{
    use HasFactory;

    protected $table = 'class_visit_rates';

    protected $guarded = []; 

    public function ClassRoomVisit()
    {
        return $this->belongsTo(ClassRoomVisitSession::class,'classVisit_id');    
    }

        // Define the relationship with VisitMethod
    public function visitMethods()
    {
        return $this->belongsToMany(VisitMethod::class, 'visit_method_class_visit', 'class_visit_rate_id', 'visit_method_id');
    }

    // Accessor to convert visit_method_ids to an array
    public function getVisitMethodIdsAttribute($value)
    {
        return explode(',', $value);
    }
    public function className()
    {
        return $this->belongsTo(ClassName::class,'class_id');    
    }
    public function period()
    {
        return $this->belongsTo(Period::class);    
    }
    public function subject()
    {
        return $this->belongsTo(Subject::class);    
    }
}
