<?php

namespace App\Models\ManagerDashboard\ClassRoomVisits;

use App\Models\AdminDashboard\School\Period;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\AdminDashboard\School\Subject;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClassRoomVisitSession extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = [];

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

    public function rate_namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'rate_namazeg_version_id')->with('namozeg');
    }


    public function teacher()
    {
        return $this->belongsTo(SchoolEmployee::class, 'school_teacher_id');
    }
    public function class()
    {
        return $this->belongsTo(SchoolClass::class, 'school_class_id')->with('className');
    }

    public function className()
    {
        return  SchoolClass::where('class_name_id', $this->class_id)->first();
    }
    public function visitOfficer()
    {
        return $this->belongsTo(SchoolEmployee::class, 'visit_officer_id');
    }
    public function period()
    {
        return $this->belongsTo(Period::class, 'visit_period_id');
    }

    public function semester()
    {
        return $this->belongsTo(SchoolSemester::class, 'semester_id');
    }

    public function subject()
    {
        return $this->belongsTo(Subject::class, 'subject_id');
    }
}
