<?php

namespace App\Models\ManagerDashboard\AbsenseAndLateness;

use App\Models\AdminDashboard\Procedures\LateProcedure\LateProcedure;
use App\Traits\CascadeSoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class StudentLatenessProcedureMainItem extends Model
{
    use SoftDeletes,HasFactory,CascadeSoftDeletes;

    protected $table='std_lateness_procedures_main_items';
    protected $guarded=[];
    protected $cascadeDeletes = ['subProcedures'];

    public function procedureStudent(){
        return $this->belongsTo(StudentLatenessProcedure::class,'student_procedure_id');
    }

    public function procedure(){
        return $this->belongsTo(LateProcedure::class,'procedure_id');
    }

    public function subProcedures(){
        return $this->hasMany(StudentLatenessProcedureSubItem::class,'main_item_id');
    }

    protected $hidden = ['created_at','updated_at','deleted_at'];
}
