<?php

namespace App\Models\ManagerDashboard\AbsenseAndLateness;

use App\Models\AdminDashboard\Procedures\AbsenceProcedure\AbsenceProcedure;
use App\Traits\CascadeSoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class StudentAbsenceProcedureMainItem extends Model
{
    use SoftDeletes,HasFactory,CascadeSoftDeletes;

    protected $table='std_absence_procedures_main_items';
    protected $guarded=[];
    protected $cascadeDeletes = ['subProcedures'];

    public function procedureStudent(){
        return $this->belongsTo(StudentAbsenceProcedure::class,'student_procedure_id');
    }

    public function procedure(){
        return $this->belongsTo(AbsenceProcedure::class,'procedure_id');
    }

    public function subProcedures(){
        return $this->hasMany(StudentAbsenceProcedureSubItem::class,'main_item_id');
    }

    protected $hidden = ['created_at','updated_at','deleted_at'];
}
