<?php

namespace App\Models\ManagerDashboard\AbsenseAndLateness;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\AdminDashboard\School\Student;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Traits\CascadeSoftDeletes;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class StudentAbsenceProcedure extends Model
{
    use SoftDeletes,HasFactory,CascadeSoftDeletes;

    protected $table='students_absence_procedures';
    protected $guarded=[];
    protected $appends = ['created_at_options'];
    protected $cascadeDeletes = ['mainProcedures'];

    public function getCreatedAtOptionsAttribute()
    {
        return Helper::getDateOptions($this->created_at, 'coptic');
    }

    protected function createdAt(): Attribute
    {
        return Attribute::make(
            get: fn ($value) => \Carbon\Carbon::parse($value)->format('d/m/Y'),
        );
    }

    public function student(){
        return $this->belongsTo(Student::class,'student_id');
    }

    public function semester(){
        return $this->belongsTo(SchoolSemester::class,'semester_id');
    }

    public function namozegVersion(){
        return $this->belongsTo(NamazegVersion::class,'namozeg_version_id');
    }

    public function mainProcedures(){
        return $this->hasMany(StudentAbsenceProcedureMainItem::class,'student_procedure_id');
    }

}
