<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class GradeViolation extends Model
{ 
    use HasFactory,SoftDeletes;

    protected $table='violation_grades';
    protected $guarded=[];

    public function violation_titles(){
        return $this->hasMany(ViolationTitle::class,'violation_grade_id')->with('violation_name', 'punishments');
    }
    public function types()
    {
        return $this->hasMany(ViolationType::class, 'violation_grade_id');
    }
    public function violation_category(){
        return $this->belongsTo(Violation::class,'violation_id');
    }
}
