<?php

namespace App\Models\AdminDashboard\School;

use Alkoumi\LaravelHijriDate\Hijri;
use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentCommitteeData;
use App\Models\ManagerDashboard\Messages\MessageReciver;
use App\Models\ManagerDashboard\Namazeg\Violations\StudentViolationDegrees;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class Student extends Model
{
    use SoftDeletes, HasFactory;

    protected $table = 'school_students';
    protected $guarded = [];

    public static function boot(){
        parent::boot();

        self::creating(function ($student) {
            $student->student_number = self::setStudentNumber($student);
        });
    }

    public static function setStudentNumber($student)
    {

        // Get the latest student in the same school
        $latestStudent = self::where('school_id', $student->school_id)
            ->where('class_id', $student->class_id)
            ->orderByDesc('id')
            ->first();

        // If no student exists in this class, start from 1
        $lastNumber = $latestStudent ? (int) $latestStudent->student_number : 0;

        // Pad the new number with 2 digits (e.g., 01, 02, ..., 99)
        $newStudentNumber = str_pad($lastNumber + 1, 2, '0', STR_PAD_LEFT);

    
        return $newStudentNumber;
    }


    public function my_notification()
    {
        return $this->hasOne(MessageReciver::class, 'user_id', 'id')
            ->orderBy('updated_at', 'Desc')
            ->with('message');
    }

    public function schoolClass()
    {
        return $this->belongsTo(SchoolClass::class, 'class_id')->with('className');
    }

    public function school()
    {
        return $this->belongsTo(School::class)->with('schoolGrade');
    }

    public function violationDegrees()
    {
        return $this->hasMany(StudentViolationDegrees::class, 'student_id');
    }

    public function getSeatNumberAttribute()
    {

        // SeatNumber
        $current_year = substr(Hijri::Date('Y'), -2);
        $className = $this->schoolClass?->className?->level_number;
        $classNumber = $this->schoolClass?->class_number;
        $studentNumber = $this->student_number;
        $baseSeatNumber = $current_year . $className . $classNumber . $studentNumber;

        return $baseSeatNumber;
    }

    public function studentCommitteeData()
    {
        return $this->hasMany(StudentCommitteeData::class, 'student_id');
    }
}
