<?php

namespace App\Models\AdminDashboard\School;

use App\Models\ManagerDashboard\Exams\NamazegPlans\MonitorDistributions\DistributionAssignment;
use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentCommittee;
use App\Models\ManagerDashboard\Tables\ClassRoomVisits\ClassroomVisit;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Week;
use App\Traits\CascadeSoftDeletes;

class SchoolSemester extends Model
{
    use SoftDeletes,CascadeSoftDeletes;

    protected $table='semesters';
    protected $cascadeDeletes = ['vacations'];

    public function weeks()
    {
        return $this->hasMany(Week::class);
    }

    public function vacations()
    {
        return $this->hasMany(SchoolSemesterVacation::class,'semester_id');
    }

    public function classVisits()
    {
        return $this->hasMany(ClassroomVisit::class,'semester_id');
    }
    public function exam_student_committees()
    {
        return $this->hasMany(StudentCommittee::class,'semester_id');
    }

    public function monitorDistribution()
    {
        return $this->hasMany(DistributionAssignment::class,'semester_id');
    }
}
