<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RegisteredSchoolEmployeeMail extends Mailable
{
    use Queueable, SerializesModels;

    protected $school_employee;

    public function __construct($school_employee)
    {
        $this->school_employee = $school_employee;
    }

    public function build()
    {
        return $this->from('example@example.com')
                    ->subject('Welcome to Our Platform')
                    ->view('emails.registered_school_employee')
                    ->with(['school_employee' => $this->school_employee]);
    }
}
