<?php

namespace App\Jobs;

use App\Helpers\Helper;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SaveSchedulesJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $schoolId;

    /**
     * Create a new job instance.
     */
    public function __construct($schoolId)
    {
        $this->schoolId = $schoolId;
    }

    /**
     * Execute the job.
     */
    public function handle()
    {
        // Call the helper methods
        Helper::saveTeacherSchedules($this->schoolId);
        Helper::saveSupervisionSchedules($this->schoolId);
        Helper::managerPLans($this->schoolId);
    }
}
