<?php

namespace App\Http\Resources\Violation;
use App\Models\Violation;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;
use App\Http\Resources\Violation\ViolationResource;


class GradeViolationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'violation_grade_id'=>$this->id,
            'name'=>$this->name,
            'types' => ViolationTypeResource::collection($this->types),
            'violations'=> ViolationTitleResource::collection($this->violation_titles()->paginate($request->per_page))
        ];
    }
}
