<?php
namespace App\Http\Resources;

use App\Helpers\Helper;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class TrashedRecordResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $deleted_at = Carbon::parse($this->deleted_at);
        $remaining = 30 - Carbon::now()->diffInDays($deleted_at);

        return [
            'id' => $this->id,
            'record_id' => $this->record_id,
            'model' => $this->model,
            'section' => $this->section,
            'file_name' => $this->namozegVersion->namozeg->name,
            'deleted_at' => Helper::getDateOptions($deleted_at->format('d/m/Y'),'coptic'),
            'remaining_period' => $remaining >=0 ? $remaining : 0,
            'serial_number' => $this->namozegVersion->serial_number,
            'form_number' => $this->namozegVersion->namozeg->form_number,
        ];
    }
}
