<?php

namespace App\Http\Resources\School;

use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolClass;
use Illuminate\Http\Resources\Json\JsonResource;

class SchoolStudentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');
        return [
            'id'=>$this->id,
            'name'=>$this->name ,
            'nationality'=>$this->nationality ,
            'ssn'=>$this->ssn ,
            'phone'=>$this->phone ,
            'class_name'=>$this->schoolClass?->className?->name,
            'class_number'=>$this->schoolClass?->class_number,
            'entsab'=>$this->schoolClass?->entsab,
            'school_grade'=>$this->school?->schoolGrade?->name,
            'class_category'=>$this->SchoolClass?->className?->category,
            'seat_number' => $this->seat_number
        ];
    }
}
