<?php

namespace App\Http\Resources\School;

use App\Http\Resources\ManagerDashboard\AbsenseAndLateness\StudentAttendanceResource;
use App\Http\Resources\ManagerDashboard\AbsenseAndLateness\StudentLatenessResource;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentAbsenceProcedure;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentAbsenceProcedureMainItem;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentAttendance;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentLateness;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentLatenessProcedure;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentLatenessProcedureMainItem;
use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentSeatingNumber;
use App\Models\ManagerDashboard\Namazeg\Violations\StudentViolationDegrees;
use App\Models\ManagerDashboard\Violations\ViolationStudent;
use App\Models\ManagerDashboard\Violations\ViolationStudentPunishment;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class SchoolStudentMoreInfoResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lateDaysCount = StudentLateness::where('student_id', $this->id)->count();
        $absentDaysCount = StudentAttendance::where('student_id', $this->id)->count();
        $lateDays = StudentLatenessResource::collection(StudentLateness::where('student_id', $this->id)->get());
        $absentDays = StudentAttendanceResource::collection(StudentAttendance::where('student_id', $this->id)->get());

        return [
            'id' => $this->id,
            'name' => $this->name,
            'nationality' => $this->nationality,
            'ssn' => $this->ssn,
            'phone' => $this->phone,
            'class_name' => $this->schoolClass?->className?->name,
            'class_number' => $this->schoolClass?->class_number,
            'entsab'=>$this->schoolClass?->entsab,
            'school_grade' => $this->school?->schoolGrade?->name,
            'class_category' => $this->SchoolClass?->className?->category,
            'late_days_Count' => $lateDaysCount,
            'absent_days_count' => $absentDaysCount,
            'late_days' => $lateDays,
            'absent_days' => $absentDays,
            'absence_and_lateness' => $this->transformStudentAbsenceAndLateness($this->id, $this->school_id, $this->class_id),
            'violations' => $this->transformStudentViolations($this->id),
            'exams' => $this->transformStudentExmas($this->id)

        ];
    }

    private function transformStudentAbsenceAndLateness($studentId, $schoolId, $class_id)
    {
        // Set locale to Arabic
        Carbon::setLocale('ar');

        $student_absence = StudentAttendance::with('semester')
            ->select('id', 'semester_id', 'date', 'absence_reason')
            ->whereIn('status', ['absent', 'absent_with_excuse'])
            ->where('student_id', $studentId)
            ->where('school_id', $schoolId)
            ->where('class_id', $class_id)
            ->get();

        // Fetch the student's absence procedure
        $studentAbsenceProcedure = StudentAbsenceProcedure::where('school_id', $schoolId)
            ->where('student_id', $studentId)
            ->first();

        if ($studentAbsenceProcedure) {
            // Fetch the main absence procedures with related data
            $mainAbsenceProcedures = StudentAbsenceProcedureMainItem::join('absence_procedures', 'std_absence_procedures_main_items.procedure_id', '=', 'absence_procedures.id')
                ->with([
                    'procedure.procedureName', // Ensure the relationships are loaded
                    'subProcedures'
                ])
                ->where('student_procedure_id', $studentAbsenceProcedure->id)
                ->where('std_absence_procedures_main_items.status', 'done')
                ->orderBy('absence_procedures.absence_dayes', 'ASC') // Use the correct table name
                ->select('std_absence_procedures_main_items.*') // Select main table columns
                ->get();

            // Transform the data
            $AbsenceActions = $mainAbsenceProcedures->map(function ($item) use ($studentAbsenceProcedure) {
                $firstSubProcedure = $item->subProcedures->first();

                return [
                    'absence_days' => $item->procedure?->absence_dayes,
                    'student_name' => $studentAbsenceProcedure?->student?->name,
                    'created_at' => $firstSubProcedure
                        ? Carbon::parse($firstSubProcedure->created_at)->translatedFormat('l d F Y')
                        : null,
                    'procedure_name' => $item->procedure?->procedureName?->name,
                    'excuted_procedures' => $item->subProcedures,
                ];
            })->toArray();
        } else {
            $AbsenceActions = [];
        }

        $index = 1;
        $absence = $student_absence->map(function ($absence_item) use ($AbsenceActions, &$index) {
            $actions = array_filter($AbsenceActions, function ($item) use ($index) {
                return $index == $item['absence_days'];
            });

            $index++;
            return [
                'semester_name' => $absence_item->semester->name,
                'date' => Carbon::createFromFormat('d/m/Y', $absence_item->date)->translatedFormat('l d F Y'),
                'absence_reason' => $absence_item->absence_reason,
                'actions' => $actions,
            ];
        });

        ///////////////////lateness///////////////////
        $student_lateness = StudentLateness::with('semester')
            ->select('id', 'date', 'semester_id', 'lateness_reason')
            ->whereIn('status', ['late', 'late_with_excuse'])
            ->where('student_id', $studentId)
            ->where('school_id', $schoolId)
            ->where('class_id', $class_id)
            ->get();

        // Fetch the student's absence procedure
        $studentLatenessProcedure = StudentLatenessProcedure::where('school_id', $schoolId)
            ->where('student_id', $studentId)
            ->first();

        if ($studentLatenessProcedure) {
            // Fetch the main absence procedures with related data
            $mainLatenessProcedures = StudentLatenessProcedureMainItem::join('late_procedures', 'std_lateness_procedures_main_items.procedure_id', '=', 'late_procedures.id')
                ->with([
                    'procedure.procedureName', // Ensure the relationships are loaded
                    'subProcedures'
                ])
                ->where('student_procedure_id', $studentLatenessProcedure->id)
                ->where('std_lateness_procedures_main_items.status', 'done')
                ->orderBy('late_procedures.late_dayes', 'ASC') // Use the correct table name
                ->select('std_lateness_procedures_main_items.*') // Select main table columns
                ->get();

            // Transform the data
            $LatenessActions = $mainLatenessProcedures->map(function ($item) use ($studentLatenessProcedure) {
                $firstSubProcedure = $item->subProcedures->first();

                return [
                    'late_days' => $item->procedure?->late_dayes,
                    'student_name' => $studentLatenessProcedure?->student?->name,
                    'created_at' => $firstSubProcedure
                        ? Carbon::parse($firstSubProcedure->created_at)->translatedFormat('l d F Y')
                        : null,
                    'procedure_name' => $item->procedure?->procedureName?->name,
                    'excuted_procedures' => $item->subProcedures,
                ];
            })->toArray();
        } else {
            $LatenessActions = [];
        }

        $index = 1;
        $lateness = $student_lateness->map(function ($lateness_item) use ($LatenessActions, &$index) {
            $actions = array_filter($LatenessActions, function ($item) use ($index) {
                return $index == $item['late_days'];
            });

            $index++;

            return [
                'semester_name' => $lateness_item->semester->name,
                'date' => Carbon::createFromFormat('d/m/Y', $lateness_item->date)->translatedFormat('l d F Y'),
                'lateness_reason' => $lateness_item->lateness_reason,
                'actions' => $actions,
            ];
        });

        $data = [
            'absence' => $absence,
            'lateness' => $lateness,
        ];

        return $data;
    }

    private function transformStudentViolations($studentId)
    {
        $student_violations = ViolationStudent::with('type', 'violationGrade', 'violation_titles')->where('student_id', $studentId)->get();
        $violations = $student_violations->flatMap(function ($student_violation) {
            $actions = $student_violation->violation_titles->map(function ($violation_title) use ($student_violation) {
                $namazeg = ViolationStudentPunishment::where('violation_student_title_id', $violation_title->id)->get()->pluck('namozeg.name'); // GradeViolationsHelper::get_violation_namazeg_nessaccery_only($violation_title->id);
                return [
                    'name' => $student_violation->other_type ?? $student_violation->type->name,
                    'grade' => $student_violation->violationGrade?->name,
                    'type' => $student_violation->other_type ?? $student_violation->type->name,
                    'created_at' => $student_violation->created_at->format('d/m/Y'),
                    'violation_date' => Carbon::createFromFormat('d/m/Y', $student_violation->date)->translatedFormat('l d F '),
                    'violation_name' => $violation_title->title->violation_name?->name,
                    'namazeg' => $namazeg,
                ];
            });

            return $actions;
        });
        $n_return = StudentViolationDegrees::where('student_id', $studentId)->where('good_value', '!=', null)->count();
        $data = [
            'n_return' => $n_return,
            'n_vioaltions' => $student_violations->count(),
            'student_vioaltions' => $violations
        ];
        return $data;
    }

    private function transformStudentExmas($studentId)
    {
        $studentExmas = StudentSeatingNumber::where('student_id', $studentId)->get();
        if (is_null($studentExmas)) {
            return [];
        }

        return $studentExmas->map(function ($studentExma) {
            return [
                'id' => $studentExma->id,
                'semester' => $studentExma->semester->name,
                'committee' => $studentExma->committee->name,
                'seat_number' => $studentExma->seat_number,
            ];
        })->all();
    }
}
