<?php

namespace App\Http\Resources\School;
use Illuminate\Http\Resources\Json\JsonResource;

class SchoolShortInfoResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'shift'=>$this->shift,
            'gender'=>$this->gender,
            'childhood'=>$this->childhood?$this->childhood:'no',
            'school_grade'=>$this->schoolGrade?->name,
            'name'=>$this->name,
            'ministry_number'=>$this->ministry_number,
            'education_type'=>$this->education_type,
            'education_department'=>$this->educationDepartment?->name,
            'educational_office'=>$this->educationalOffice?->name,
            'founding_date'=>$this->founding_date,
            'founding_date_type'=>$this->founding_date_type,
            'address'=>$this->address,
            'area'=>$this->area?->name,
            'city'=>$this->city?->name,
        ];
    }
}
