<?php

namespace App\Http\Resources\School;
use Illuminate\Http\Resources\Json\JsonResource;

class SchoolEmployeeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $account_status = $this->user?->status;
        return [
            'id'=> $this->id,
            'name'=> $this->name,
            'ssn'=> $this->ssn,
            'phone'=> $this->phone,
            'email'=> $this->email,
            'current_work'=> $this->currentWork?->job_title,
            'specialization'=> $this->specialization?->title,
            'user_id'=>$this->user?->id,
            'have_account'=>$this->have_account,
            'account_status'=>trans("api.$account_status"),
        ];
    }
}
