<?php

namespace App\Http\Resources\School;
use App\Http\Resources\School\SchoolEmployeeAttendanceResource;
use App\Models\AdminDashboard\School\SchoolEmployeeAttendance;
use Illuminate\Http\Resources\Json\JsonResource;
class SchoolEmployeeAttendanceHistoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $absentDays = SchoolEmployeeAttendanceResource::collection(SchoolEmployeeAttendance::where('school_employee_id',$this->id)->where('status','absent')->get());
        $lateDays = SchoolEmployeeAttendanceResource::collection(SchoolEmployeeAttendance::where('school_employee_id',$this->id)->where('status','late')->get());

        $absentDaysCount = SchoolEmployeeAttendance::where('school_employee_id',$this->id)->where('status','absent')->count();
        $lateDaysCount = SchoolEmployeeAttendance::where('school_employee_id',$this->id)->where('status','late')->count();

        $lang = $request->header('lang');
        return [
            'id'=> $this->id,
            'name'=> $this->name,
            'ssn'=> $this->ssn,
            'phone'=> $this->phone,
            'email'=> $this->email,
            'current_work'=> $this->currentWork?->job_title,
            'specialization'=> $this->specialization?->title,

            'absentDayCount'=> $absentDaysCount,
            'lateDaysCount'=> $lateDaysCount,
            'absentDays'=> $absentDays,
            'lateDays'=> $lateDays,
        ];
    }
}
