<?php

namespace App\Http\Resources\School;

use App\Http\Resources\ManagerDashboard\TeacherSchedule\TeacherScheduleResource;
use Illuminate\Http\Resources\Json\JsonResource;

class SchoolClassResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');
        return [
            'id'=>$this->id,
            'grade'=> $this->className?->grade?->name,
            'class_name'=> $this->className?->name,
            'class_number'=> $this->class_number,
            'category'=> $this->className?->category,
            'n_students'=>$this->n_students,
            'entsab'=>$this->entsab,
        ];
    }
}
