<?php

namespace App\Http\Resources\School;

use App\Helpers\Helper;
use Illuminate\Http\Resources\Json\JsonResource;

class GuideRegulationFileResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');
        return [
            'id'=>$this->id,
            'file_name' => $this->file_name,
            'guide_regulation_id'=>$this->guide_regulation_id,
            'guide_regulation_name'=>$this->guideRegulation?->name,
            'guide_regulation_path'=> $this->file_path ?? null,
            'publish_date' => $this->publish_date,
            'publish_date_type' =>(isset($this->publish_date_type)) ? trans('api.'.$this->publish_date_type) : '',
            'date_options'=> Helper::getDateOptions($this->publish_date, $this->publish_date_type),
            'file_size' => $this->file_size,
        ];
    }
}
