<?php

namespace App\Http\Resources\School;

use Illuminate\Http\Resources\Json\JsonResource;

class ClassNameResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');
        return [
            'id'=>$this->id,
            'grade'=> $this->grade?->name,
            'name'=> $this->name,
            'category'=> $this->category,
            'classes' =>  $this->schoolClasses->map(function ($schoolClass) {
                return [
                    'school_class_id' => $schoolClass->id,
                    'class_number' => $schoolClass->class_number
                ];
            })
        ];
    }
}
