<?php

namespace App\Http\Resources\ManagerDashboard\ViolationStudents;

use Illuminate\Http\Resources\Json\JsonResource;

class ViolationStudentDetailsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $grade_date = GradeViolationStudentResource::collection($this->violation_grades);
        $n_category_count = 0;

        foreach ($grade_date as $grade_date_item) {
            $violationArray = $grade_date_item->toArray($request);

            if (isset($violationArray['n_grade_count'])) {
                $n_category_count += $violationArray['n_grade_count'];
            }
        }

        return [
            'violation_category_id' => $this->id,
            'violation_category_name' => $this->name,
            'n_category_count' => $n_category_count,
            'violation_grades' => $grade_date
        ];
    }

}
