<?php

namespace App\Http\Resources\ManagerDashboard\ViolationStudents;

use App\Helpers\GradeViolationsHelper;
use App\Helpers\Helper;
use App\Http\Controllers\Api\ManagerDashboard\Violations\ManagerViolationController;
use App\Models\ViolationTitle;
use App\Models\ManagerDashboard\Violations\ViolationStudent;
use App\Models\ManagerDashboard\Violations\ViolationStudentTitle;
use Illuminate\Http\Resources\Json\JsonResource;


class NamazegviolationStudentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $violation_title_ids = [$this->id];
        $violation_title_id_done = ViolationStudentTitle::whereIn('violation_student_id', $violation_title_ids)
            ->where('status', 'done')
            ->pluck('violation_title_id')
            ->toArray();

        $violation_titles = GradeViolationsHelper::violationTitles($this->violation_grade_id);
        $violation_titles = $violation_titles->map(function ($violation_title) use ($violation_title_id_done) {
            $done = in_array($violation_title->id, $violation_title_id_done);
            // Pass $this directly as the ViolationStudent instance
            $student_violation = ViolationStudent::find($this->resource->id);
            $namazeg = ManagerViolationController::violation_title_details($student_violation, $violation_title);

            return [
                'violation_title_id'=> $violation_title->id,
                'id' => $violation_title->violation_name->id,
                'name' => $violation_title->violation_name->name,
                'done' => $done,
                'namazeg' => $namazeg ? $namazeg->original['data']['punishments'] : null,
            ];
        });

        return [
            'student_violation_id' => $this->id,
            'serial_number' => $this->namozegVersion?->serial_number,
            'type_name' => $this->violation_type_id ? $this->type?->name : $this->other_type,
            'date' => $this->date ? Helper::getDateOptions($this->date, 'coptic') : '',
            'created_at' => Helper::getDateOptions($this->created_at->format('d/m/Y'), 'coptic'),
            'violation_titles' => $violation_titles->sortBy('id')->values(),
        ];
    }
}
