<?php

namespace App\Http\Resources\ManagerDashboard\TeamAndCommitteeMeetings;

use App\Helpers\Helper;
use Illuminate\Http\Resources\Json\JsonResource;

class MeetingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        // $created_at = \Carbon\Carbon::parse($this->created_at)->format('d/m/Y');
        $lang = $request->header('lang');
        return [
            'id'=> $this->id,
            'name' => $this->name,
            'school_id' => $this->school_id,
            'serial_number' => $this?->namozegVersion?->serial_number,
            'model_type' => $this->model_type,
            'model_id' => $this->model_id,
            'meeting_type' => $this->meeting_type,
            'date' => $this->date,
            'date_type' => (isset($this->date_type)) ? $this->date_type : '',
            'date_options'=> $this->date_options,
            'start_time' => $this->start_time,
            'end_time' => $this->end_time,
            'place' => $this->place,
            'attendances_count' => $this->attendances_count,
            'target_audience' => $this->target_audience,
            'meeting_status' => $this->meeting_status,
            'created_at' => $this->created_at,
            'created_at_options'=> Helper::getDateOptions($this->created_at, 'coptic'),
            'meeting_scheduals' => $this->meetingScheduals,
            'recommendations' => $this->meetingRecommendations,
        ];
    }
}
