<?php

namespace App\Http\Resources\ManagerDashboard\TeacherSchedule;

use App\Http\Resources\ManagerDashboard\TeacherSchedule\TeacherScheduleDataResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class SchoolClassResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'teacher_schedual_id'=>$this->id,
            'class_name'=>$this->class?->className?->name,
            'class_number'=>$this->class?->class_number,
            'semester_id'=>$this->semester_id,
            'created_at' => $this->schedule_data->isNotEmpty()?Carbon::parse($this->created_at)->format('d/m/Y'):__('api.not_created_yet'),
            'teacher_schedule' => TeacherScheduleDataResource::collection($this->schedule_data)  
        ];
    }
}
