<?php

namespace App\Http\Resources\ManagerDashboard\Tables\Exams;

use App\Http\Resources\School\SubjectResource;
use Illuminate\Http\Request;
use App\Models\ManagerDashboard\Tables\Exams\TableExamDayExam;
use Illuminate\Http\Resources\Json\JsonResource;

class TableExamDayResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'day'=>$this->semesterWeekDay?->day?->name.'',
            'date'=>$this->semesterWeekDay?->date.'',
            'n_exams'=>$this->n_exams,
            'leave_time'=>$this->leave_time?$this->leave_time:'',
            'exams'=>$this->dayExams($this->id),

        ];
    }

    /** mapping day exams*/
    private function dayExams($dayExamId){
        $exams = TableExamDayExam::where('table_exam_day_id', $dayExamId)->get();
        return $exams->map(function ($exam) {
            return [
                'subject' => $exam->subject?->name,
                'subject_id' => $exam->subject_id,
                'start_time' => $exam->start_time,
                'end_time' => $exam->end_time,

            ];
        });
    }
}
