<?php

namespace App\Http\Resources\ManagerDashboard\Reports\SchoolAdminstrativeReport;
use App\Models\AdminDashboard\School\SchoolEmployeeAttendance;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AbsentTeacherResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $absentWithExcuse = SchoolEmployeeAttendance::where('school_employee_id',$this->id)->where('status','absent')->where('absence_reason','!=','without_excuse')->count();
        $absentWithOutExcuse = SchoolEmployeeAttendance::where('school_employee_id',$this->id)->where('status','absent')->where('absence_reason','without_excuse')->count();
        return [
            'id'=>$this->id,
            'employee_name'=>$this->name,
            'ssn'=>$this->ssn,
            'absent_with_excuse'=>$absentWithExcuse,
            'absent_without_excuse'=>$absentWithOutExcuse,
            'absent_days_by_month' => $this->getAbsentDaysByMonth($this->id),
        ];
    }

    public function getAbsentDaysByMonth($employeeId){
        $absences = SchoolEmployeeAttendance::where('school_employee_id', $employeeId)
            ->where('status', 'absent')
            ->get();

        $monthlyAbsences = $absences->groupBy(function($attendance) {
            return Carbon::createFromFormat('d/m/Y', $attendance->date)->format('n');
        })->mapWithKeys(function ($days, $month) {
            return [$month => $days->count()];
        });
        $fullYearAbsences = [];
        for ($month = 1; $month <= 12; $month++) {
            $fullYearAbsences[$month] = $monthlyAbsences[$month] ?? 0;
        }
        return (object) $fullYearAbsences;
    }
}
