<?php

namespace App\Http\Resources\ManagerDashboard\Notification;

use App\Helpers\Helper;
use App\Models\Notification;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class NotificationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        Carbon::setlocale('ar');
        if($this->notification->date){
            $date =Carbon::createFromFormat('d/m/Y',$this->notification->date)->translatedFormat(' D , d/m/Y', 'ar');
        }else{
            $date =$this->updated_at->translatedFormat(' D , d/m/Y', 'ar');

        }
        return [
            'id' => $this->id,
            'title' => $this->notification->title,
            'body' => $this->notification->body,
            'type' => $this->notification->type,
            'date' => $date,
            'model' => $this->notification->model,
            'model_id' => $this->notification->model_id,
            'item_id' => $this->notification->data_id,
            'seen' => $this->seen,
            'open' => $this->open,
        ];
    }
}
