<?php

namespace App\Http\Resources\ManagerDashboard\NamazegPrint;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolEmployeeAttendance;
use App\Models\AdminDashboard\School\SemesterWeekDay;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentAttendance;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentLateness;
use App\Models\Week;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;
use Hamcrest\Type\IsInteger;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Validation\Rules\NotIn;

class NamazegManagerPlaneResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */

    public function toArray($request)
    {
        if (is_numeric($this->week_id)) {
            [$first_day, $last_day] = Helper::get_first_last_semester_Day($this->week_id, $this->semester_id);
            $first_date = $first_day->date;
            $last_date = $last_day->date;
        } else {
            [$first_day, $last_day] = Helper::get_first_last_semester_Day(1, $this->semester_id);
            $first_date = Carbon::createFromFormat('d/m/Y', $first_day->date)->subDays($this->week_id == "الإسبوع التمهيدي" ? 7 : 14)->format('d/m/Y');
            $last_date = Carbon::createFromFormat('d/m/Y', $last_day->date)->subDays($this->week_id == "الإسبوع التمهيدي" ? 7 : 14)->format('d/m/Y');
        }
        if ($this->week_id == "note") {
            $grouped_details = "Notes Relation to create ";
        } elseif ($this->week_id == "suggestions") {
            $grouped_details = "Suggestions Relation to create ";
        } else {
            $grouped_details = $this->plane_details->groupBy('type')->map(function ($items, $type) {
                return [
                    'items' => $items->map(function ($item) {
                        return [
                            'work_details' => $item->work_details,
                            'days' => $item->days ? json_decode($item->days, true) : [],
                            'achieved'=> json_decode($item->achieved, true),
                        ];
                    }),
                ];
            });
        }
        $static_data = [
            'توزيع المهام بين المعلمين',
            'توزيع الجداول على المعلمين',
            'توزيع الإشراف اليومي والمناوية',
            'توزيع النشاط والريادة',
            'عقد الاجتماع الأول لعموم المعلمين',
            'عقد الاجتماع الأول لمجلس الإدارة',
            'عقد الاجتماع الأول لمجلس النشاط',
            'عقد الاجتماع الأول للجان التوجيه الحالات السلوكية',
            'نظافة المبنى وتوزيع الطاولات والكراسي حسب الميزانية',
            'تعليق اللوحات الإرشادية',
            'عقد الاجتماع الأول للجنة خطة الإخلاء',
            'الاجتماع برؤساء الأقسام'
        ];
        $statis_grouped_details['suggested_work']['items'] = [];

        // $grouped_details = count($grouped_details) > 0 ? $grouped_details : $statis_grouped_details;
        if (!isset($grouped_details['suggested_work'])) {
            $grouped_details['suggested_work'] = [
                'items' => []
            ];
        }
        if (!isset($grouped_details['work_to_be_done'])) {
            $grouped_details['work_to_be_done'] = [
                'items' => collect($static_data)->map(function ($item) {
                    return [
                        'work_details' => $item,
                        'days' => [], // Set as an empty array
                        'achieved' => [], // Set as an empty array
                    ];
                })->toArray()
            ];
        }

        $days = SemesterWeekDay::where('semester_id', $this->semester_id)
            ->where('week_id', $this->week_id)->orderBy('day_id')
            ->where('day_id','<','6')
            ->get();
        $dates = $days->pluck('date')->toArray();
        //students
        $absent_students_count = StudentAttendance::where('school_id', $this->school_id)
            ->where('semester_id', $this->semester_id)
            ->whereIn('status', ['absent', 'absent_with_excuse'])
            ->whereIn('date', $dates)
            ->selectRaw('date, 
             CASE WHEN ANY_VALUE(status) = "absent" THEN "without" ELSE "with" END as status
             , COUNT(*) as count')
            ->groupBy('date', 'status')
            ->get();

        $late_students_count = StudentLateness::where('school_id', $this->school_id)
            ->where('semester_id', $this->semester_id)
            ->whereIn('status', ['late', 'late_with_excuse'])
            ->whereIn('date', $dates)
            ->selectRaw('date,  
                CASE WHEN ANY_VALUE(status) = "late" THEN "without" ELSE "with" END as status
            , COUNT(*) as count')
            ->groupBy('date', 'status')
            ->get();
        //teachers
        $late_teachers_count = SchoolEmployeeAttendance::where('school_id', $this->school_id)
            ->where('type', 'teacher')
            ->where('status', 'late')
            ->whereIn('date', $dates)
            ->selectRaw(
                'date, 
        CASE WHEN ANY_VALUE(absence_reason) = "without_excuse" THEN "without" ELSE "with" END as status, 
        COUNT(*) as count'
            )
            ->groupBy('date', 'status')
            ->get();

        $absent_teachers_count = SchoolEmployeeAttendance::where('school_id', $this->school_id)
            ->where('type', 'teacher')
            ->where('status', 'absent')
            ->whereIn('date', $dates)
            ->selectRaw(
                'date, CASE WHEN ANY_VALUE(absence_reason) = "without_excuse" THEN "without" ELSE "with" END as status, 
                COUNT(*) as count'
            )
            ->groupBy('date', 'status')
            ->get();

        //students
        $grouped_absent_students = collect($dates)->map(function ($date) use ($absent_students_count, $days) {

            $dayData = $absent_students_count->where('date', $date);

            $statuses = [
                ['status' => 'without', 'count' => 0],
                ['status' => 'with', 'count' => 0]
            ];


            foreach ($dayData as $item) {
                foreach ($statuses as &$status) {
                    if ($status['status'] === $item->status) {
                        $status['count'] = $item->count;
                    }
                }
            }


            return [
                'day_id' => $days->where('date', $date)->first()?->day_id,
                'statuses' => $statuses
            ];
        });

        $grouped_late_students = collect($dates)->map(function ($date) use ($late_students_count, $days) {
            $dayData = $late_students_count->where('date', $date);
            $statuses = [
                ['status' => 'without', 'count' => 0],
                ['status' => 'with', 'count' => 0]
            ];


            foreach ($dayData as $item) {
                foreach ($statuses as &$status) {
                    if ($status['status'] === $item->status) {
                        $status['count'] = $item->count;
                    }
                }
            }


            return [
                'day_id' => $days->where('date', $date)->first()?->day_id,
                'statuses' => $statuses
            ];
        });

        //teachers
        $grouped_late_teachers = collect($dates)->map(function ($date) use ($late_teachers_count, $days) {
            $dayData = $late_teachers_count->where('date', $date);
            $statuses = [
                ['status' => 'without', 'count' => 0],
                ['status' => 'with', 'count' => 0]
            ];


            foreach ($dayData as $item) {
                foreach ($statuses as &$status) {
                    if ($status['status'] === $item->status) {
                        $status['count'] = $item->count;
                    }
                }
            }


            return [
                'day_id' => $days->where('date', $date)->first()?->day_id,
                'statuses' => $statuses
            ];
        });

        $grouped_absent_teachers = collect($dates)->map(function ($date) use ($absent_teachers_count, $days) {
            $dayData = $absent_teachers_count->where('date', $date);
            $statuses = [
                ['status' => 'without', 'count' => 0],
                ['status' => 'with', 'count' => 0]
            ];


            foreach ($dayData as $item) {
                foreach ($statuses as &$status) {
                    if ($status['status'] === $item->status) {
                        $status['count'] = $item->count;
                    }
                }
            }


            return [
                'day_id' => $days->where('date', $date)->first()?->day_id,
                'statuses' => $statuses
            ];
        });

        if ($grouped_details instanceof \Illuminate\Support\Collection) {
            $grouped_details = $grouped_details->toArray();
        }

        if (!isset($grouped_details['absents_data'])) {
            $grouped_details['absents_data'] = [];
        }

        // Now assign the absent students data
        $grouped_details['absents_data']['late_teachers'] = $grouped_late_teachers;
        $grouped_details['absents_data']['absent_teachers'] = $grouped_absent_teachers;
        $grouped_details['absents_data']['late_students'] = $grouped_late_students;
        $grouped_details['absents_data']['absent_students'] = $grouped_absent_students;
        return [
            'id' => $this->id,
            'serial_number' => $this->namozegVersion->serial_number,
            'form_number' => $this->namozegVersion->namozeg->form_number,
            'title' => $this->title,
            'first_date' => Helper::getDateOptions($first_date, "coptic"),
            'last_date' => Helper::getDateOptions($last_date, "coptic"),
            'semester' => $this->semester->name,
            'week' => $this->week_name,
            'details' =>  $grouped_details,

        ];
    }
}
