<?php

namespace App\Http\Resources\ManagerDashboard\Namazeg;

use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class NotifyLateLeavingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $data = [
            'id' => $this->id,
            'serial_number' => $this->namozegVersion->serial_number,
            'employee_name' => $this->employee->name,
            'date' => Carbon::createFromFormat('d/m/Y', $this->date)->translatedFormat('d F Y', 'ar'),
            'level' => $this->level,
            'type' => $this->type,
            'created_at' =>  $this->created_at->translatedFormat('d F Y', 'ar')
        ];
        if ($this->type == "during") {
            $data['start_date'] = $this->start_date;
            $data['end_date'] = $this->end_date;
        } elseif ($this->type == "start") {
            $data['start_date'] = $this->start_date;
            // $data['start_date'] = Carbon::parse($this->start_date)->translatedFormat('d F Y', 'ar');
        } else {
            $data['end_date'] = $this->end_date;
            // $data['end_date'] = Carbon::parse($this->end_date)->translatedFormat('d F Y', 'ar');
        }
        return $data;
    }
}
