<?php

namespace App\Http\Resources\ManagerDashboard\Namazeg;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SemesterWeekDay;
use App\Models\Notification;
use App\Models\AdminDashboard\School\SchoolSemester;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class NamazegPlaneResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        //current_semester
        $current_semester = Helper::getCurrentSchoolSemester();
        $this_semester = SchoolSemester::find($this->semester_id);

        //current_today
        $today = Carbon::today();
        $status_time = SemesterWeekDay::where('semester_id', $this->semester_id)->where('week_id', $this->week_id)->orderBy('day_id', 'Desc')
            ->where('date', $today->format('d/m/Y'))->first();
        $status_week_first_day = SemesterWeekDay::where('semester_id', $this->semester_id)->where('week_id', $this->week_id)->orderBy('day_id', 'Asc')->first();
        $status_week_end_day = SemesterWeekDay::where('semester_id', $this->semester_id)->where('week_id', $this->week_id)->orderBy('day_id', 'Desc')->first();
        $mainly_start_Date = $status_week_first_day ? Carbon::createFromFormat('d/m/Y', $status_week_first_day?->date) : null;
        $mainly_end_Date = $status_week_first_day ? Carbon::createFromFormat('d/m/Y', $status_week_end_day?->date) : null;

        $actual_status_time =  __('api.done');

        if ($status_time) {
            $actual_status_time =  __('api.notdone');
        } elseif ($this_semester->id > $current_semester->id && $status_week_first_day?->date && $status_week_end_day?->date) {
            if ($today->greaterThan($mainly_start_Date) && $today->lessThan($mainly_end_Date)) {
                $actual_status_time =  __('api.notdone');
            } elseif ($today->lessThan($mainly_start_Date) && $today->lessThan($mainly_end_Date)) {
                // next semsters
                $actual_status_time =  __('api.notdone');
            }
        } elseif ($this_semester->id >= $current_semester->id && in_array($this->week_id, [110, NULL])) {
            $actual_status_time =  __('api.notdone');
        }


        return [
            'id' => $this->id,
            'serial_number' => $this->namozegVersion->serial_number,
            'title' => $this->title,
            'week' => $this->week_name,
            'mainly_start_Date' => $status_week_end_day,
            'mainly_end_Date' => $mainly_end_Date,
            'today' => $today,
            'semester' => $this->semester->name,
            'status_time' => $actual_status_time,
            'status_data' => count($this->plane_details) ? true : false
        ];
    }
}
