<?php

namespace App\Http\Resources\ManagerDashboard\Namazeg;

use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class AssignProfessionalResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'serial_number' => $this->namozegVersion->serial_number,
            'employee' => $this->assign_employee->map(function($employee){
                return $employee->employee?->name;
            }),           
            'specilization' => $this->specialization->title,
            'created_at' =>  $this->created_at->translatedFormat('d F Y', 'ar'),
        ];
    }
}
