<?php

namespace App\Http\Resources\ManagerDashboard\Namazeg;

use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class AcceptStudentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'serial_number' => $this->namozegVersion->serial_number,
            'student_name' => $this->student_name,
            'nationality' => $this->nationality,
            'class_name' => $this->class?->name,
            'from_school_manager' => $this->from_school_manager,
            'created_at' =>  $this->created_at->translatedFormat('d F Y', 'ar')
        ];
    }
}
