<?php

namespace App\Http\Resources\ManagerDashboard\LetterAndAlart;

use App\Helpers\Helper;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class LetterResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'school_id' => $this->school_id,
            'form_number' => $this->namozegVersion?->namozeg?->form_number,
            'serial_number' => $this->namozegVersion?->serial_number,
            'type' => $this->type,
            'date_type' => $this->date_type,
            'date' => Carbon::createFromFormat('d/m/Y', $this->date)->format('d/m/Y'),
            'date_options' => Helper::getDateOptions($this->date, $this->type),
            'title' => $this->title,
            'letter_for' => $this->letter_for,
            'details' => $this->details,         
        ];
    }
}
