<?php

namespace App\Http\Resources\ManagerDashboard\Exams\SupervisionCommittees;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SupervisionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        return
            [
                'id' => $this->id,
                'name' => $this->name,
                'assignment_form_number' => $this->assignment_form_number,
                'assignment' => $this->assignment ? [
                    'id' => $this->assignment->id,
                    'school_id' => $this->assignment->school_id,
                    'round' => $this->assignment->round,
                    'serial_number' => $this->assignment->namozegVersion?->serial_number,
                    'created_at' => Carbon::parse($this->assignment->created_at)->format('j-n-Y'),
                    'members' => $this->assignment->members->map(function ($member) {
                        return
                            [
                                'employee_id' => $member->employee->id,
                                'name' => $member->employee->name,
                                'currentWork' => $member->employee?->currentWork?->job_title,
                                'assignment_work' => $member->assignment_work,
                                'mission' => $member->mission
                            ];
                    }),
                ] : []
            ];
    }
}
