<?php

namespace App\Http\Resources\ManagerDashboard\Exams\SupervisionCommittees;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CorrectionAssignmentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'school_id' => $this->school_id,
            'serial_number' => $this->namozegVersion?->serial_number,
            'round' => $this->round,
            'subject_id' => $this->subject_id,
            'subject' => $this->subject->name,
            'location' => $this->location,
            'members' => $this->members->map(function ($member) {
                return [
                    'id' => $member->employee->id,
                    'name' => $member->employee->name,
                    'assignment_work' =>  $member->assignment_work,
                    'mission' =>  $member->mission ?? null,
                ];
            }),
        ];
    }
}
