<?php

namespace App\Http\Resources\ManagerDashboard\Exams\StudentCommittes;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

use function PHPUnit\Framework\isEmpty;

class CommitteeDataResource extends JsonResource
{

    private $students;
    private $committee_plan;
    private $class_names;

    public function __construct($resource, $students,$class_names, $committee_plan)
    {
        parent::__construct($resource);
        $this->students = $students;
        $this->committee_plan = $committee_plan;
        $this->class_names = $class_names;
    }

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'committe_id' => $this->id,
            'semester_id' => $this->semester_id,
            'semester_name' => $this->semester->name,
            'serial_number' => $this->namozegVersion?->serial_number,
            'schoolClass_id' => $this->schoolclass_id,
            'schoolClass_name' => $this->school_class_name ?? ' ',
            'name' => $this->name,
            'location' => $this->location,
            'serial_number' => $this->namozegVersion?->serial_number,
            'formation_type' => $this->formation_type,
            'status' => $this->status,
            'students_count' => $this->students->count(),
            'students' => $this->students->map(function ($student) {

                return [
                    'student_id' => $student->id,
                    'name' => $student->name,
                    'school_class_id' => $student->class_id,
                    'class_name' => $student->schoolClass?->className?->name,
                    'class_number' => $student->schoolClass->class_number,
                    'seat_number' => $student->seat_number,

                ];
            }),

            'class_name' => $this->class_names->map(function ($class_name) {
                return [
                    'class_name' => $class_name->class_name,
                    'students_count' =>  $class_name->students_count
                ];
            }),
            'committee_plan' => $this->when(
                optional($this->committee_plan)->isNotEmpty(),
                function () {
                    $committeePlanCount = $this->committee_plan->count();

                    return [
                        'column_numbers' => $committeePlanCount,
                        'column_data' => $this->committee_plan->map(function ($column_data) {
                            return [
                                'column_number' => $column_data->column_number,
                                'class_name' => $column_data->class_name,
                                'student_count' => $column_data->student_count,
                                'students' => $column_data->students->map(fn($student) => [
                                    'id' => $student->id,
                                    'name' => $student->name,
                                    'seat_number' => $student->seat_number
                                ])
                            ];
                        })
                    ];
                }
            )
        ];
    }
}
