<?php

namespace App\Http\Resources\ManagerDashboard\Exams\NamazegPlans;

use App\Models\AdminDashboard\School\SchoolEmployee;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

use function PHPUnit\Framework\isEmpty;

class DailyObservesResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray($request): array
    {
        return [
            "data" => $this->map(function ($semester) {
                return [
                    'id' => $semester->id,
                    'name' => $semester->name,
                    'monitorDistribution' => $semester->monitorDistribution->map(function ($distribution) {
                        return [
                            'monitors' => $distribution->monitors->map(function ($monitor) {

                                Carbon::setLocale('ar');

                                // Parse the date and get the day in Arabic
                                $day = Carbon::createFromFormat('d/m/Y', $monitor->date)->locale('ar')->translatedFormat('l');

                                return [
                                    'id' => $monitor->id,
                                    'employee_id' => $monitor->employee_id,
                                    'name' => $monitor->employee->name,
                                    'day' =>   $day,
                                    'date' => $monitor->date,
                                    'period' => $monitor->period,
                                    'status' => $monitor->dailyObserve ? 'complated' : 'incomplated',
                                    'dailyObserve' => $monitor->dailyObserve ? [
                                        'id' => $monitor->dailyObserve->id,
                                        'school_id' => $monitor->dailyObserve->school_id,
                                        'serial_number' => $monitor->dailyObserve->namozegVersion?->serial_number,
                                        'committee_id' => $monitor->dailyObserve->committee_id,
                                        'committee_name' => $monitor->dailyObserve->exam_comittee->name,
                                        'committee_location' => empty($monitor->dailyObserve->exam_comittee->CommitteeData)
                                            ? $monitor->dailyObserve->exam_comittee->name
                                            : (isset($monitor->dailyObserve->exam_comittee->CommitteeData[0])
                                                ? $monitor->dailyObserve->exam_comittee->CommitteeData[0]->location
                                                : $monitor->dailyObserve->exam_comittee->name),
                                        'subject_id' => $monitor->dailyObserve->subject_id,
                                        'subject_name' =>  $monitor->dailyObserve->subject->name,
                                        'exam_time' =>  $monitor->dailyObserve->exam_time,
                                        'employees' => $monitor->dailyObserve->employees_ids ? collect(json_decode($monitor->dailyObserve->employees_ids))->map(function ($employeeId) {
                                            $employee = SchoolEmployee::find($employeeId);
                                            return $employee ? [
                                                'id' => $employee->id,
                                                'name' => $employee->name,
                                            ] : null;
                                        })->values() : [],
                                    ] : null,
                                ];
                            }),
                        ];
                    }),
                ];
            }),
        ];
    }
}
