<?php

namespace App\Http\Resources\ManagerDashboard\Circulars;

use Illuminate\Http\Resources\Json\JsonResource;

class TeacherGeneralCircularResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');
        return [
            'id'=> $this->id,
            'type'=> 'teacherCirculars',
            'school_id' => $this->school_id,
            'serial_number'=> $this?->namozegVersion?->serial_number,
            'school_name' => $this->school->name,
            'title' => $this->title,
            'created_at' => $this->created_at,
            'teachers' => $this->teachers,
        ];
    }
}
