<?php

namespace App\Http\Resources\ManagerDashboard\Assignments;

use App\Helpers\Helper;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AssignmentCurrentWorkResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->job_title ?? $this->name, // Handle both job title and committee/team name
            'assignment_form_number' => $this->assignment_form_number ?? null,

            'assignments' => $this->assignments ? $this->assignments->map(function ($assignment) {
                return [
                    'id' => $assignment->id,
                    'namozeg_serial_number' => $assignment->namozegVersion?->serial_number,
                    'date' => $assignment->date ?? 'No date',
                    'date_options' => Helper::getDateOptions($assignment->date, $assignment->type),
                    'employees' => $assignment->assignmentEmployees->map(function ($assignmentEmployee) {
                        return [
                            'employee_id' => $assignmentEmployee->employee?->id,
                            'name' => $assignmentEmployee->employee?->name ?? 'No name',
                            'phone' => $assignmentEmployee->employee?->phone ?? Null,
                            'email' => $assignmentEmployee->employee?->email ?? Null,
                            'civil_record_number' => $assignmentEmployee->employee?->ssn ?? 'No SSN',
                            'specialization' => $assignmentEmployee->employee?->specialization->title ?? 'No specialization',
                            'current_work' => $assignmentEmployee->employee?->currentWork->job_title ?? Null,

                        ];
                    }),
                ];
            }) : [],
        ];
    }
}
