<?php

namespace App\Http\Resources\ManagerDashboard\Assignments;

use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Committee;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AssignmentCategoryResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'jobs' => AssignmentCurrentWorkResource::collection($this->whenLoaded('jobs')),
            'committeesAssignments' => $this->when(isset($this->committeesAssignments), $this->committeesAssignments),
            'teamsAssignments' => $this->when(isset($this->teamsAssignments), $this->teamsAssignments),
            'generalAssignments' => $this->when(isset($this->generalAssignments), $this->generalAssignments), // Add this line

        ];
    }
}