<?php

namespace App\Http\Resources\Event;

use App\Helpers\Helper;
use App\Http\Resources\BaseResource;
use App\Models\Event;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class EventResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'title'=>$this->title,
            'duration'=>$this->duration,
            'date_from_options'=> Helper::getDateOptions($this->date_from, 'coptic'),
            'date_to_options'=> Helper::getDateOptions($this->date_to, 'coptic'),
            'holiday'=>$this->holiday,
        ];
    }
}
