<?php

namespace App\Http\Resources\AdminDashboard\Procedures;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class LateProcedureResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $lateForms = $this->lateForms()->select('id','form_number', 'name','details','type')->get();
        // Transform the collection to remove 'pivot' information
        $formattedLateForms = $lateForms->map(function ($lateForm) {
            return [
                'id' => $lateForm->id,
                'name' => $lateForm->name,
                'form_number'=>$lateForm->form_number,
                'details' => $lateForm->details,
                 'type'=> $lateForm->type,
            ];
        });
        return [
            'id'=> $this->id,
            'name'=> $this->procedureName?->name,
            'late_dayes' => $this->late_dayes,
            'late_procedures_forms'=>  $formattedLateForms->toArray(),
            'details' => $this->details,
            'status'=>($this->status == 1)?trans('api.active'):trans('api.inactive'),  
        ];
    }
}
