<?php

namespace App\Http\Resources\AdminDashboard\Procedures;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AbsenceProcedureResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
       
        $absenceForms = $this->absenceForms()->select('id','form_number', 'name','details','type')->get();
        
        // Transform the collection to remove 'pivot' information
        $formattedAbsenceForms = $absenceForms->map(function ($absenceForm) {
            return [
                'id' => $absenceForm->id,
                'name' => $absenceForm->name,
                'form_number'=>$absenceForm->form_number,
                'details' => $absenceForm->details,
                'type'=> $absenceForm->type,
              
            ];
        });
        return [
            'id'=> $this->id,
            'name'=> $this->procedureName?->name,
            'absence_dayes' => $this->absence_dayes,
            'absence_procedures_forms'=>  $formattedAbsenceForms->toArray(),
            'details' => $this->details,
            'status'=>($this->status == 1)?trans('api.active'):trans('api.inactive'),  
        ];
    }
}
