<?php

namespace App\Http\Resources\AdminDashboard\Finances;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class TransactionPaymentGatewayResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        return [
            'id' => $this->id,
            'order_number' => $this->order_number,
            'invoice_number' => $this->invoice_number,
            'user' => $this->user->name,
            'school' => $this->school?->name,
            'total_price' => $this->total_price,
            'payment_method' => $this->transactionPaymentGatewayData?->payment_method,
            'paid_status' => $this->paid_status,
            'paid_date' => Carbon::createFromFormat('Y-m-d H:i:s', $this->transactionPaymentGatewayData?->trans_date)
                ->locale('ar')
                ->translatedFormat('d F Y')
        ];
    }
}
