<?php

namespace App\Http\Resources\AdminDashboard\Finances;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BankTransactionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'invoice_number' => $this->invoice_number,
            'school' => $this->school?->name,
            'total_price' => $this->total_price,
            'paid_status' => $this->paid_status,
            'paid_date' => $this->transactionData?->transfer_date,
            'transfer_receipt' => $this->transactionData?->transfer_receipt ? url('public/uploads/TransferReceipts/' . $this->transactionData->transfer_receipt) : Null
        ];
    }
}
